#ifndef _GRAPH_H
#define _GRAPH_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define GRAPH_LEFT  0
#define GRAPH_RIGHT 1

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

typedef struct _GraphProps
{
    POINT*  GraphPtr;
    POINT*  LGraphPtr;
    COLORREF  GraphColor;
    COLORREF  GridColor;
    UCHAR  UpdateInterval;
    UCHAR  StepSize;
    BOOL  Frozen;
    BOOL  Direction;
}GraphProps, *LPGRAPHPROPS;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void DrawGraph(HWND hWnd, DWORD BGColor);
void InitGraph(HWND hWnd, COLORREF GRColor, COLORREF GridColor, UCHAR StepSize, BOOL Direction);
void CloseGraph(HWND hWnd);
void UpdateGraph(HWND hWnd, int UpdtVal, int MaxVal);
void FreezeGraph(HWND hWnd, BOOL FreezeStatus);
BOOL IsGraphFrozen(HWND hWnd);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
